function [residual, g1, g2, g3] = World_Economy_Cartel_cost_inv_shocks_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 76, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T33 = params(32)^(-1);
T36 = exp(y(22));
T50 = exp(y(1))*y(36)+T33*y(44)*(-(T36*exp(y(1))*exp(y(11))))+T33*y(47)*(-(exp(y(1))*T36));
T69 = params(12)^(1-params(4));
T88 = params(13)^(1-params(4));
T127 = exp(y(4))*exp(y(27))*params(6)*exp(y(34))^(params(5)-1);
T128 = exp(y(1))*exp(y(4))-T127;
T167 = exp(y(6))*params(6)*exp(y(26))*exp(params(5)*y(10));
T182 = exp(y(6))*y(49)+params(32)*y(40)*T167+params(32)*y(49)*(-(exp(y(6))*(1-exp(y(10)))))+params(32)*y(53)*(-(exp(y(6))*exp(y(10))));
T191 = exp(y(7))*exp(y(27))*params(6)*exp(y(11)*params(5));
T192 = y(40)*T191;
T205 = exp(y(7))*y(48)+params(32)*T192+params(32)*y(48)*(-(exp(y(7))*(1-exp(y(11)))))+params(32)*y(52)*(-(exp(y(11))*exp(y(7))));
T246 = params(32)*y(53)*(-(exp(y(6))*exp(y(10))))+params(32)*y(40)*exp(y(6))*params(6)*exp(y(26))*params(5)*exp(params(5)*y(10))+params(32)*y(49)*(-(exp(y(6))*(-exp(y(10)))));
T259 = y(47)*T36*params(6)*params(5)*exp(y(26))*(params(5)-1)*exp(y(11)*(params(5)-1));
T268 = (-(T36*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*exp(y(26))*params(5)*exp(y(11)*params(5)))));
T269 = y(44)*T268;
T319 = exp(y(16))^(1/params(2));
T321 = (-1)/params(2);
T323 = exp(y(15))*getPowerDeriv(exp(y(15)),T321,1);
T329 = (params(2)-1)/params(2);
T331 = exp(y(15))*getPowerDeriv(exp(y(15)),T329,1);
T341 = exp(y(17))^params(3);
T343 = exp(y(18))^(1-params(3));
T344 = T341*T343;
T345 = T344^T329;
T349 = (1-params(11))*exp(T329*y(23))*T345+params(11)*exp(y(15))^T329;
T351 = getPowerDeriv(T349,params(2)/(params(2)-1),1);
T364 = exp(y(17))^(params(3)-1);
T365 = T344^T321;
T369 = exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),1);
T378 = exp(y(18))^(-params(3));
T387 = exp(y(15))^T321;
T403 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3),1);
T405 = getPowerDeriv(T344,T329,1);
T407 = (1-params(11))*exp(T329*y(23))*T343*T403*T405;
T412 = T319*exp(T329*y(23))*(1-params(11))*(1-params(3));
T415 = getPowerDeriv(T344,T321,1);
T416 = T343*T403*T415;
T419 = T403*T365*T412+T341*T412*T416;
T425 = T319*exp(T329*y(23))*(1-params(11))*params(3);
T430 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,1);
T434 = (-(T343*(T364*T416*T425+T365*T425*T430)));
T460 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T463 = (-(params(9)*T460/(1+params(8))));
T464 = getPowerDeriv(T18,(-params(14)),1);
T465 = T463*T464;
T478 = (-(exp(T329*y(23))*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
T482 = exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),1);
T497 = exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),1);
T503 = (1-params(11))*exp(T329*y(23))*T405*T341*T482;
T551 = params(9)^((-1)/params(8));
T556 = exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),1);
T567 = T36*params(6)*params(5)*exp(y(26))*exp(y(11)*(params(5)-1))-T36*(exp(y(1))-y(13));
T583 = (-(T36*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(26))*exp(y(11)*params(5)))));
T592 = T33*y(47)*T567+T36*y(43)+T33*y(42)*(-(T36*(1+exp(y(20))-params(10))))+T33*y(44)*T583+T33*y(45)*(-(y(14)*T36*(1-params(7))));
T619 = T345*(1-params(11))*T329*exp(T329*y(23));
T626 = params(32)^2;
T681 = y(40)*T167+T33*y(44)*(-(T36*(-(params(6)*exp(y(26))*exp(y(11)*params(5))))))+T33*y(47)*T36*params(6)*params(5)*exp(y(26))*exp(y(11)*(params(5)-1));
T715 = exp(y(34))*getPowerDeriv(exp(y(34)),params(5)-1,1);
T718 = (-(exp(y(4))*exp(y(27))*params(6)*T715));
T719 = T21*T718;
residual(1) = T21*exp(y(1))*exp(y(4))+(-y(61))+T50+y(61)*params(32);
residual(2) = T21*(-(exp(y(25))*exp(y(2))))+(-y(63))+y(51)*(-(T69*params(4)*exp(y(2)*params(4))))+exp(y(25))*exp(y(2))*y(40)+params(32)*y(63);
residual(3) = (-y(62))+y(50)*(-(T88*params(4)*exp(params(4)*y(3))))+y(46)*y(14)*T88*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+y(40)*exp(y(24))*exp(y(3))+params(32)*y(62);
residual(4) = T21*T128+(-y(65))+y(54)*(-exp(y(4)))+exp(y(4))*y(53)+params(32)*y(65);
residual(5) = (-y(64))+y(54)*(-exp(y(5)))+exp(y(5))*y(52)+params(32)*y(64);
residual(6) = T182;
residual(7) = T205;
residual(8) = y(51)*exp(y(8))+y(49)*(-(exp(y(8))*params(7)))+params(32)*y(51)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(50)*exp(y(9))+y(48)*(-(params(7)*exp(y(9))))+params(32)*y(50)*(-((1-params(7))*exp(y(9))));
residual(10) = T246+params(32)*(-exp(y(10)))*y(60);
residual(11) = params(32)*y(52)*(-(exp(y(11))*exp(y(7))))+T259+T269+params(32)*y(40)*exp(y(7))*exp(y(27))*params(6)*params(5)*exp(y(11)*params(5))+params(32)*y(48)*(-(exp(y(7))*(-exp(y(11)))));
residual(12) = exp(y(12))*y(39);
residual(13) = y(45)*(-params(7))+y(44)+T33*y(44)*(-(T36*(1-exp(y(11)))))+T33*T36*y(47);
residual(14) = y(46)*T88*params(4)*exp(y(3)*(params(4)-1))+y(45)+T33*y(45)*(-(T36*(1-params(7))));
residual(15) = y(54)*exp(y(15))+y(36)*(-(params(11)*T319*T323))+y(35)*(-(params(11)*T331*T351));
residual(16) = (-y(66))+y(40)*(-exp(y(16)))+y(38)*(-(T343*T364*T365*exp(T329*y(23))*(1-params(11))*params(3)*T369))+y(37)*(-(T378*T341*T365*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))))+y(36)*(-(T387*params(11)*T369))+exp(y(16))*y(35)+params(32)*y(66);
residual(17) = y(40)*exp(y(17))+params(32)*y(35)*(-(T351*T407))+params(32)*y(37)*(-(T378*T419))+params(32)*y(38)*T434+params(32)*y(39)*(-(exp(y(18)*(1-params(3)))*exp(T329*y(23))*params(3)*exp(y(17)*params(3))))+params(32)*y(40)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T128-exp(y(25))*exp(y(2)))*T465+y(43)*(-(T465*params(1)/T21))+exp(y(18))*y(41)+y(39)*T478+y(38)*(-(T364*T365*T425*T482+T343*T364*T425*T415*T341*T482))+y(37)*(-(T378*T341*T412*T415*T341*T482+T341*T365*T412*T497))+y(35)*(-(T351*T503))+params(32)*y(43)*(-((-(T465*T21*params(1)))/(T21*T21)));
residual(19) = (T128-exp(y(25))*exp(y(2)))*exp(y(19))*T464+y(43)*(-(params(1)*exp(y(19))*T464/T21))+exp(y(19))*y(40)+params(32)*y(43)*(-((-(T21*params(1)*exp(y(19))*T464))/(T21*T21)));
residual(20) = y(38)*exp(y(20))+T33*y(42)*(-(T36*exp(y(20))));
residual(21) = y(41)*(-(T551*T556))+y(37)*exp(y(21));
residual(22) = T592;
residual(23) = y(55)+params(32)*y(55)*(-params(15))+y(39)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T329*exp(T329*y(23))))+y(38)*(-(T343*T364*T365*T319*(1-params(11))*params(3)*T329*exp(T329*y(23))))+y(37)*(-(T378*T341*T365*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))))+y(35)*(-(T351*T619))+T626*y(55)*(-params(16));
residual(24) = y(56)+params(32)*y(56)*(-params(18))+y(40)*exp(y(24))*exp(y(3))+y(46)*(-exp(y(24)))+T626*y(56)*(-params(19));
residual(25) = T21*(-(exp(y(25))*exp(y(2))))+y(57)+params(32)*y(57)*(-params(21))+exp(y(25))*exp(y(2))*y(40)+T626*y(57)*(-params(22));
residual(26) = y(58)+params(32)*y(58)*(-params(24))+T681+T626*y(58)*(-params(25));
residual(27) = T21*(-T127)+y(59)+params(32)*y(59)*(-params(27))+T192+T626*y(59)*(-params(28));
residual(28) = y(61);
residual(29) = y(62);
residual(30) = y(63);
residual(31) = y(64);
residual(32) = y(65);
residual(33) = y(66);
residual(34) = T719+exp(y(34))*y(60);
residual(35) = exp(y(16))-T349^(params(2)/(params(2)-1));
residual(36) = exp(y(1))-params(11)*T319*T387;
residual(37) = exp(y(21))-T378*T341*T365*T412;
residual(38) = exp(y(20))-T343*T364*T365*T425;
residual(39) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T329*y(23))*exp(y(17)*params(3));
residual(40) = T167+T191+exp(y(25))*exp(y(2))+exp(y(24))*exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(41) = exp(y(18))-T551*exp(y(21))^(1/params(8));
residual(42) = 1-T36*(1+exp(y(20))-params(10));
residual(43) = T36-T21*params(1)/T21;
residual(44) = y(13)-T36*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(26))*exp(y(11)*params(5)));
residual(45) = y(14)-(y(14)*T36*(1-params(7))+params(7)*y(13));
residual(46) = y(14)*T88*params(4)*exp(y(3)*(params(4)-1))-exp(y(24));
residual(47) = T567;
residual(48) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(49) = exp(y(6))-(exp(y(6))*(1-exp(y(10)))+exp(y(8))*params(7));
residual(50) = exp(y(9))-((1-params(7))*exp(y(9))+T88*exp(params(4)*y(3)));
residual(51) = exp(y(8))-(exp(y(8))*(1-params(7))+T69*exp(y(2)*params(4)));
residual(52) = exp(y(5))-exp(y(11))*exp(y(7));
residual(53) = exp(y(4))-exp(y(6))*exp(y(10));
residual(54) = exp(y(15))-(exp(y(4))+exp(y(5)));
residual(55) = y(23)-(x(5)+y(23)*params(15)+y(23)*params(16));
residual(56) = y(24)-(x(2)+y(24)*params(18)+y(24)*params(19));
residual(57) = y(25)-(x(1)+y(25)*params(21)+y(25)*params(22));
residual(58) = y(26)-(x(4)+y(26)*params(24)+y(26)*params(25));
residual(59) = y(27)-(x(3)+y(27)*params(27)+y(27)*params(28));
residual(60) = exp(y(34))-exp(y(10));
residual(61) = y(28);
residual(62) = y(29);
residual(63) = y(30);
residual(64) = y(31);
residual(65) = y(32);
residual(66) = y(33);
lhs =y(67);
rhs =y(55);
residual(67)= lhs-rhs;
lhs =y(68);
rhs =y(56);
residual(68)= lhs-rhs;
lhs =y(69);
rhs =y(57);
residual(69)= lhs-rhs;
lhs =y(70);
rhs =y(58);
residual(70)= lhs-rhs;
lhs =y(71);
rhs =y(59);
residual(71)= lhs-rhs;
lhs =y(72);
rhs =y(23);
residual(72)= lhs-rhs;
lhs =y(73);
rhs =y(24);
residual(73)= lhs-rhs;
lhs =y(74);
rhs =y(25);
residual(74)= lhs-rhs;
lhs =y(75);
rhs =y(26);
residual(75)= lhs-rhs;
lhs =y(76);
rhs =y(27);
residual(76)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(76, 76);

  %
  % Jacobian matrix
  %

T994 = params(32)*y(52)*(-(exp(y(11))*exp(y(7))))+params(32)*y(40)*exp(y(7))*exp(y(27))*params(6)*params(5)*exp(y(11)*params(5))+params(32)*y(48)*(-(exp(y(7))*(-exp(y(11)))));
T1053 = getPowerDeriv(T349,params(2)/(params(2)-1),2);
T1078 = T369+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),2);
T1105 = y(37)*(-(T378*(T365*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))*T403+T341*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))*T416)));
T1113 = y(38)*(-(T343*(T364*exp(T329*y(23))*(1-params(11))*params(3)*T369*T416+T365*exp(T329*y(23))*(1-params(11))*params(3)*T369*T430)));
T1130 = y(38)*(-(T364*T365*exp(T329*y(23))*(1-params(11))*params(3)*T369*T482+T343*T364*exp(T329*y(23))*(1-params(11))*params(3)*T369*T415*T341*T482))+y(37)*(-(T378*T341*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))*T415*T341*T482+T341*T365*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))*T497));
T1143 = y(38)*(-(T343*T364*T365*T369*(1-params(11))*params(3)*T329*exp(T329*y(23))))+y(37)*(-(T378*T341*T365*T369*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))));
T1152 = T403+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3),2);
T1154 = getPowerDeriv(T344,T329,2);
T1169 = getPowerDeriv(T344,T321,2);
T1173 = T415*T343*T1152+T343*T403*T343*T403*T1169;
T1255 = y(38)*(-(T343*(T430*T365*T319*(1-params(11))*params(3)*T329*exp(T329*y(23))+T364*T416*T319*(1-params(11))*params(3)*T329*exp(T329*y(23)))));
T1262 = y(37)*(-(T378*(T403*T365*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))+T341*T416*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23)))));
T1317 = getPowerDeriv(T18,(-params(14)),2);
T1321 = T464*(-(params(9)*(T460+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2))/(1+params(8))))+T463*T463*T1317;
T1337 = T482+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),2);
T1426 = y(38)*(-(T482*T364*T365*T319*(1-params(11))*params(3)*T329*exp(T329*y(23))+T343*T364*T415*T341*T482*T319*(1-params(11))*params(3)*T329*exp(T329*y(23))));
T1433 = y(37)*(-(T497*T341*T365*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))+T378*T341*T415*T341*T482*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))));
T1510 = T33*y(44)*(-(T36*(-(params(6)*exp(y(26))*exp(y(11)*params(5))))))+T33*y(47)*T36*params(6)*params(5)*exp(y(26))*exp(y(11)*(params(5)-1));
  g1(1,1)=T21*exp(y(1))*exp(y(4))+T50;
  g1(1,4)=T21*exp(y(1))*exp(y(4));
  g1(1,11)=T33*y(44)*(-(T36*exp(y(1))*exp(y(11))));
  g1(1,18)=exp(y(1))*exp(y(4))*T465;
  g1(1,19)=exp(y(1))*exp(y(4))*exp(y(19))*T464;
  g1(1,22)=T33*y(44)*(-(T36*exp(y(1))*exp(y(11))))+T33*y(47)*(-(exp(y(1))*T36));
  g1(1,36)=exp(y(1));
  g1(1,44)=T33*(-(T36*exp(y(1))*exp(y(11))));
  g1(1,47)=T33*(-(exp(y(1))*T36));
  g1(1,61)=(-1)+params(32);
  g1(2,2)=T21*(-(exp(y(25))*exp(y(2))))+exp(y(25))*exp(y(2))*y(40)+y(51)*(-(T69*params(4)*params(4)*exp(y(2)*params(4))));
  g1(2,18)=(-(exp(y(25))*exp(y(2))))*T465;
  g1(2,19)=(-(exp(y(25))*exp(y(2))))*exp(y(19))*T464;
  g1(2,25)=T21*(-(exp(y(25))*exp(y(2))))+exp(y(25))*exp(y(2))*y(40);
  g1(2,40)=exp(y(25))*exp(y(2));
  g1(2,51)=(-(T69*params(4)*exp(y(2)*params(4))));
  g1(2,63)=(-1)+params(32);
  g1(3,3)=y(50)*(-(T88*params(4)*params(4)*exp(params(4)*y(3))))+y(40)*exp(y(24))*exp(y(3))+y(46)*y(14)*T88*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,14)=y(46)*T88*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,24)=y(40)*exp(y(24))*exp(y(3));
  g1(3,40)=exp(y(24))*exp(y(3));
  g1(3,46)=y(14)*T88*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,50)=(-(T88*params(4)*exp(params(4)*y(3))));
  g1(3,62)=(-1)+params(32);
  g1(4,1)=T21*exp(y(1))*exp(y(4));
  g1(4,4)=T21*T128+y(54)*(-exp(y(4)))+exp(y(4))*y(53);
  g1(4,18)=T128*T465;
  g1(4,19)=T128*exp(y(19))*T464;
  g1(4,27)=T21*(-T127);
  g1(4,34)=T719;
  g1(4,53)=exp(y(4));
  g1(4,54)=(-exp(y(4)));
  g1(4,65)=(-1)+params(32);
  g1(5,5)=y(54)*(-exp(y(5)))+exp(y(5))*y(52);
  g1(5,52)=exp(y(5));
  g1(5,54)=(-exp(y(5)));
  g1(5,64)=(-1)+params(32);
  g1(6,6)=T182;
  g1(6,10)=T246;
  g1(6,26)=params(32)*y(40)*T167;
  g1(6,40)=params(32)*T167;
  g1(6,49)=exp(y(6))+params(32)*(-(exp(y(6))*(1-exp(y(10)))));
  g1(6,53)=params(32)*(-(exp(y(6))*exp(y(10))));
  g1(7,7)=T205;
  g1(7,11)=T994;
  g1(7,27)=params(32)*T192;
  g1(7,40)=params(32)*T191;
  g1(7,48)=exp(y(7))+params(32)*(-(exp(y(7))*(1-exp(y(11)))));
  g1(7,52)=params(32)*(-(exp(y(11))*exp(y(7))));
  g1(8,8)=y(51)*exp(y(8))+y(49)*(-(exp(y(8))*params(7)))+params(32)*y(51)*(-(exp(y(8))*(1-params(7))));
  g1(8,49)=(-(exp(y(8))*params(7)));
  g1(8,51)=exp(y(8))+params(32)*(-(exp(y(8))*(1-params(7))));
  g1(9,9)=y(50)*exp(y(9))+y(48)*(-(params(7)*exp(y(9))))+params(32)*y(50)*(-((1-params(7))*exp(y(9))));
  g1(9,48)=(-(params(7)*exp(y(9))));
  g1(9,50)=exp(y(9))+params(32)*(-((1-params(7))*exp(y(9))));
  g1(10,6)=T246;
  g1(10,10)=params(32)*(-exp(y(10)))*y(60)+params(32)*y(53)*(-(exp(y(6))*exp(y(10))))+params(32)*y(49)*(-(exp(y(6))*(-exp(y(10)))))+params(32)*y(40)*exp(y(6))*params(6)*exp(y(26))*params(5)*params(5)*exp(params(5)*y(10));
  g1(10,26)=params(32)*y(40)*exp(y(6))*params(6)*exp(y(26))*params(5)*exp(params(5)*y(10));
  g1(10,40)=params(32)*exp(y(6))*params(6)*exp(y(26))*params(5)*exp(params(5)*y(10));
  g1(10,49)=params(32)*(-(exp(y(6))*(-exp(y(10)))));
  g1(10,53)=params(32)*(-(exp(y(6))*exp(y(10))));
  g1(10,60)=params(32)*(-exp(y(10)));
  g1(11,1)=y(44)*(-(T36*exp(y(1))*exp(y(11))));
  g1(11,7)=T994;
  g1(11,11)=params(32)*y(52)*(-(exp(y(11))*exp(y(7))))+params(32)*y(48)*(-(exp(y(7))*(-exp(y(11)))))+y(47)*T36*params(6)*params(5)*exp(y(26))*(params(5)-1)*(params(5)-1)*exp(y(11)*(params(5)-1))+y(44)*(-(T36*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*exp(y(26))*params(5)*params(5)*exp(y(11)*params(5)))))+params(32)*y(40)*exp(y(7))*exp(y(27))*params(6)*params(5)*params(5)*exp(y(11)*params(5));
  g1(11,13)=y(44)*(-(T36*(-exp(y(11)))));
  g1(11,22)=T259+T269;
  g1(11,26)=T259+y(44)*(-(T36*(-(params(6)*exp(y(26))*params(5)*exp(y(11)*params(5))))));
  g1(11,27)=params(32)*y(40)*exp(y(7))*exp(y(27))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,40)=params(32)*exp(y(7))*exp(y(27))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,44)=T268;
  g1(11,47)=T36*params(6)*params(5)*exp(y(26))*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(11,48)=params(32)*(-(exp(y(7))*(-exp(y(11)))));
  g1(11,52)=params(32)*(-(exp(y(11))*exp(y(7))));
  g1(12,12)=exp(y(12))*y(39);
  g1(12,39)=exp(y(12));
  g1(13,11)=T33*y(44)*(-(T36*(-exp(y(11)))));
  g1(13,22)=T33*y(44)*(-(T36*(1-exp(y(11)))))+T33*T36*y(47);
  g1(13,44)=1+T33*(-(T36*(1-exp(y(11)))));
  g1(13,45)=(-params(7));
  g1(13,47)=T33*T36;
  g1(14,3)=y(46)*T88*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(14,22)=T33*y(45)*(-(T36*(1-params(7))));
  g1(14,45)=1+T33*(-(T36*(1-params(7))));
  g1(14,46)=T88*params(4)*exp(y(3)*(params(4)-1));
  g1(15,15)=y(54)*exp(y(15))+y(36)*(-(params(11)*T319*(T323+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T321,2))))+y(35)*(-(T351*params(11)*(T331+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T329,2))+params(11)*T331*params(11)*T331*T1053));
  g1(15,16)=y(36)*(-(T323*params(11)*T369));
  g1(15,17)=y(35)*(-(params(11)*T331*T407*T1053));
  g1(15,18)=y(35)*(-(params(11)*T331*T503*T1053));
  g1(15,23)=y(35)*(-(params(11)*T331*T619*T1053));
  g1(15,35)=(-(params(11)*T331*T351));
  g1(15,36)=(-(params(11)*T319*T323));
  g1(15,54)=exp(y(15));
  g1(16,15)=y(36)*(-(T323*params(11)*T369));
  g1(16,16)=y(40)*(-exp(y(16)))+y(38)*(-(T343*T364*T365*exp(T329*y(23))*(1-params(11))*params(3)*T1078))+y(37)*(-(T378*T341*T365*exp(T329*y(23))*(1-params(11))*(1-params(3))*T1078))+exp(y(16))*y(35)+y(36)*(-(T387*params(11)*T1078));
  g1(16,17)=T1105+T1113;
  g1(16,18)=T1130;
  g1(16,23)=T1143;
  g1(16,35)=exp(y(16));
  g1(16,36)=(-(T387*params(11)*T369));
  g1(16,37)=(-(T378*T341*T365*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))));
  g1(16,38)=(-(T343*T364*T365*exp(T329*y(23))*(1-params(11))*params(3)*T369));
  g1(16,40)=(-exp(y(16)));
  g1(16,66)=(-1)+params(32);
  g1(17,15)=params(32)*y(35)*(-(T407*params(11)*T331*T1053));
  g1(17,16)=params(32)*T1105+params(32)*T1113;
  g1(17,17)=y(40)*exp(y(17))+params(32)*y(40)*(-(exp(y(17))*(1-params(10))))+params(32)*y(35)*(-(T407*T407*T1053+T351*(1-params(11))*exp(T329*y(23))*(T405*T343*T1152+T343*T403*T343*T403*T1154)))+params(32)*y(37)*(-(T378*(T365*T412*T1152+T403*T412*T416+T403*T412*T416+T341*T412*T1173)))+params(32)*y(38)*(-(T343*(T416*T425*T430+T364*T425*T1173+T416*T425*T430+T365*T425*(T430+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,2)))))+params(32)*y(39)*(-(exp(y(18)*(1-params(3)))*exp(T329*y(23))*params(3)*params(3)*exp(y(17)*params(3))));
  g1(17,18)=params(32)*y(35)*(-(T407*T503*T1053+T351*(1-params(11))*exp(T329*y(23))*(T405*T403*T482+T343*T403*T341*T482*T1154)))+params(32)*y(37)*(-(T419*T497+T378*(T403*T412*T415*T341*T482+T341*T412*(T415*T403*T482+T343*T403*T341*T482*T1169))))+params(32)*y(38)*(-((T364*T416*T425+T365*T425*T430)*T482+T343*(T430*T425*T415*T341*T482+T364*T425*(T415*T403*T482+T343*T403*T341*T482*T1169))))+params(32)*y(39)*(-(exp(T329*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
  g1(17,23)=params(32)*y(35)*(-(T351*T343*T403*T405*(1-params(11))*T329*exp(T329*y(23))+T407*T619*T1053))+params(32)*T1262+params(32)*T1255+params(32)*y(39)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T329*exp(T329*y(23))));
  g1(17,35)=params(32)*(-(T351*T407));
  g1(17,37)=params(32)*(-(T378*T419));
  g1(17,38)=params(32)*T434;
  g1(17,39)=params(32)*(-(exp(y(18)*(1-params(3)))*exp(T329*y(23))*params(3)*exp(y(17)*params(3))));
  g1(17,40)=exp(y(17))+params(32)*(-(exp(y(17))*(1-params(10))));
  g1(18,1)=exp(y(1))*exp(y(4))*T465;
  g1(18,2)=(-(exp(y(25))*exp(y(2))))*T465;
  g1(18,4)=T128*T465;
  g1(18,15)=y(35)*(-(T503*params(11)*T331*T1053));
  g1(18,16)=T1130;
  g1(18,17)=y(39)*(-(exp(T329*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(38)*(-((T364*T416*T425+T365*T425*T430)*T482+T343*(T430*T425*T415*T341*T482+T364*T425*(T341*T482*T343*T403*T1169+T415*T403*T482))))+y(37)*(-(T378*(T403*T412*T415*T341*T482+T341*T412*(T341*T482*T343*T403*T1169+T415*T403*T482))+T419*T497))+y(35)*(-(T503*T407*T1053+T351*(1-params(11))*exp(T329*y(23))*(T341*T482*T343*T403*T1154+T405*T403*T482)));
  g1(18,18)=(T128-exp(y(25))*exp(y(2)))*T1321+y(43)*(-((T21*params(1)*T1321-T465*T465*params(1))/(T21*T21)))+exp(y(18))*y(41)+y(39)*(-(exp(T329*y(23))*exp(y(17)*params(3))*(1-params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(38)*(-(T482*T364*T425*T415*T341*T482+T364*T365*T425*T1337+T482*T364*T425*T415*T341*T482+T343*T364*T425*(T341*T482*T341*T482*T1169+T415*T341*T1337)))+y(37)*(-(T341*T412*T415*T341*T482*T497+T378*T341*T412*(T341*T482*T341*T482*T1169+T415*T341*T1337)+T341*T412*T415*T341*T482*T497+T341*T365*T412*(T497+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),2))))+y(35)*(-(T503*T503*T1053+T351*(1-params(11))*exp(T329*y(23))*(T341*T482*T341*T482*T1154+T405*T341*T1337)))+params(32)*y(43)*(-((T21*T21*(-(T465*T465*params(1)+T21*params(1)*T1321))-(-(T465*T21*params(1)))*(T21*T465+T21*T465))/(T21*T21*T21*T21)));
  g1(18,19)=(T128-exp(y(25))*exp(y(2)))*T463*exp(y(19))*T1317+y(43)*(-((T21*params(1)*T463*exp(y(19))*T1317-T465*params(1)*exp(y(19))*T464)/(T21*T21)))+params(32)*y(43)*(-((T21*T21*(-(T465*params(1)*exp(y(19))*T464+T21*params(1)*T463*exp(y(19))*T1317))-(-(T465*T21*params(1)))*(T21*exp(y(19))*T464+T21*exp(y(19))*T464))/(T21*T21*T21*T21)));
  g1(18,23)=y(39)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T329*exp(T329*y(23))))+T1426+T1433+y(35)*(-(T351*T405*T341*T482*(1-params(11))*T329*exp(T329*y(23))+T503*T619*T1053));
  g1(18,25)=(-(exp(y(25))*exp(y(2))))*T465;
  g1(18,27)=T465*(-T127);
  g1(18,34)=T465*T718;
  g1(18,35)=(-(T351*T503));
  g1(18,37)=(-(T378*T341*T412*T415*T341*T482+T341*T365*T412*T497));
  g1(18,38)=(-(T364*T365*T425*T482+T343*T364*T425*T415*T341*T482));
  g1(18,39)=T478;
  g1(18,41)=exp(y(18));
  g1(18,43)=(-(T465*params(1)/T21))+params(32)*(-((-(T465*T21*params(1)))/(T21*T21)));
  g1(19,1)=exp(y(1))*exp(y(4))*exp(y(19))*T464;
  g1(19,2)=(-(exp(y(25))*exp(y(2))))*exp(y(19))*T464;
  g1(19,4)=T128*exp(y(19))*T464;
  g1(19,18)=(T128-exp(y(25))*exp(y(2)))*exp(y(19))*T463*T1317+y(43)*(-((T21*params(1)*exp(y(19))*T463*T1317-T465*params(1)*exp(y(19))*T464)/(T21*T21)))+params(32)*y(43)*(-((T21*T21*(-(T465*params(1)*exp(y(19))*T464+T21*params(1)*exp(y(19))*T463*T1317))-(-(T21*params(1)*exp(y(19))*T464))*(T21*T465+T21*T465))/(T21*T21*T21*T21)));
  g1(19,19)=(T128-exp(y(25))*exp(y(2)))*(exp(y(19))*T464+exp(y(19))*exp(y(19))*T1317)+y(43)*(-((T21*params(1)*(exp(y(19))*T464+exp(y(19))*exp(y(19))*T1317)-exp(y(19))*T464*params(1)*exp(y(19))*T464)/(T21*T21)))+exp(y(19))*y(40)+params(32)*y(43)*(-((T21*T21*(-(exp(y(19))*T464*params(1)*exp(y(19))*T464+T21*params(1)*(exp(y(19))*T464+exp(y(19))*exp(y(19))*T1317)))-(-(T21*params(1)*exp(y(19))*T464))*(T21*exp(y(19))*T464+T21*exp(y(19))*T464))/(T21*T21*T21*T21)));
  g1(19,25)=(-(exp(y(25))*exp(y(2))))*exp(y(19))*T464;
  g1(19,27)=exp(y(19))*T464*(-T127);
  g1(19,34)=exp(y(19))*T464*T718;
  g1(19,40)=exp(y(19));
  g1(19,43)=(-(params(1)*exp(y(19))*T464/T21))+params(32)*(-((-(T21*params(1)*exp(y(19))*T464))/(T21*T21)));
  g1(20,20)=y(38)*exp(y(20))+T33*y(42)*(-(T36*exp(y(20))));
  g1(20,22)=T33*y(42)*(-(T36*exp(y(20))));
  g1(20,38)=exp(y(20));
  g1(20,42)=T33*(-(T36*exp(y(20))));
  g1(21,21)=y(37)*exp(y(21))+y(41)*(-(T551*(T556+exp(y(21))*exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),2))));
  g1(21,37)=exp(y(21));
  g1(21,41)=(-(T551*T556));
  g1(22,1)=T33*y(44)*(-(T36*exp(y(1))*exp(y(11))))+T33*y(47)*(-(exp(y(1))*T36));
  g1(22,11)=T33*T259+T33*T269;
  g1(22,13)=T33*y(44)*(-(T36*(1-exp(y(11)))))+T33*T36*y(47);
  g1(22,14)=T33*y(45)*(-(T36*(1-params(7))));
  g1(22,20)=T33*y(42)*(-(T36*exp(y(20))));
  g1(22,22)=T592;
  g1(22,26)=T1510;
  g1(22,42)=T33*(-(T36*(1+exp(y(20))-params(10))));
  g1(22,43)=T36;
  g1(22,44)=T33*T583;
  g1(22,45)=T33*(-(y(14)*T36*(1-params(7))));
  g1(22,47)=T33*T567;
  g1(23,15)=y(35)*(-(T619*params(11)*T331*T1053));
  g1(23,16)=T1143;
  g1(23,17)=y(39)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T329*exp(T329*y(23))))+T1255+T1262+y(35)*(-(T619*T407*T1053+T351*T343*T403*T405*(1-params(11))*T329*exp(T329*y(23))));
  g1(23,18)=y(39)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T329*exp(T329*y(23))))+T1426+T1433+y(35)*(-(T619*T503*T1053+T351*T405*T341*T482*(1-params(11))*T329*exp(T329*y(23))));
  g1(23,23)=y(39)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T329*T329*exp(T329*y(23))))+y(38)*(-(T343*T364*T365*T319*(1-params(11))*params(3)*T329*T329*exp(T329*y(23))))+y(37)*(-(T378*T341*T365*T319*(1-params(11))*(1-params(3))*T329*T329*exp(T329*y(23))))+y(35)*(-(T619*T619*T1053+T351*T345*(1-params(11))*T329*T329*exp(T329*y(23))));
  g1(23,35)=(-(T351*T619));
  g1(23,37)=(-(T378*T341*T365*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))));
  g1(23,38)=(-(T343*T364*T365*T319*(1-params(11))*params(3)*T329*exp(T329*y(23))));
  g1(23,39)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T329*exp(T329*y(23))));
  g1(23,55)=1+params(32)*(-params(15))+T626*(-params(16));
  g1(24,3)=y(40)*exp(y(24))*exp(y(3));
  g1(24,24)=y(40)*exp(y(24))*exp(y(3))+y(46)*(-exp(y(24)));
  g1(24,40)=exp(y(24))*exp(y(3));
  g1(24,46)=(-exp(y(24)));
  g1(24,56)=1+params(32)*(-params(18))+T626*(-params(19));
  g1(25,2)=T21*(-(exp(y(25))*exp(y(2))))+exp(y(25))*exp(y(2))*y(40);
  g1(25,18)=(-(exp(y(25))*exp(y(2))))*T465;
  g1(25,19)=(-(exp(y(25))*exp(y(2))))*exp(y(19))*T464;
  g1(25,25)=T21*(-(exp(y(25))*exp(y(2))))+exp(y(25))*exp(y(2))*y(40);
  g1(25,40)=exp(y(25))*exp(y(2));
  g1(25,57)=1+params(32)*(-params(21))+T626*(-params(22));
  g1(26,6)=y(40)*T167;
  g1(26,10)=y(40)*exp(y(6))*params(6)*exp(y(26))*params(5)*exp(params(5)*y(10));
  g1(26,11)=T33*T259+T33*y(44)*(-(T36*(-(params(6)*exp(y(26))*params(5)*exp(y(11)*params(5))))));
  g1(26,22)=T1510;
  g1(26,26)=T681;
  g1(26,40)=T167;
  g1(26,44)=T33*(-(T36*(-(params(6)*exp(y(26))*exp(y(11)*params(5))))));
  g1(26,47)=T33*T36*params(6)*params(5)*exp(y(26))*exp(y(11)*(params(5)-1));
  g1(26,58)=1+params(32)*(-params(24))+T626*(-params(25));
  g1(27,4)=T21*(-T127);
  g1(27,7)=T192;
  g1(27,11)=y(40)*exp(y(7))*exp(y(27))*params(6)*params(5)*exp(y(11)*params(5));
  g1(27,18)=T465*(-T127);
  g1(27,19)=exp(y(19))*T464*(-T127);
  g1(27,27)=T192+T21*(-T127);
  g1(27,34)=T719;
  g1(27,40)=T191;
  g1(27,59)=1+params(32)*(-params(27))+T626*(-params(28));
  g1(28,61)=1;
  g1(29,62)=1;
  g1(30,63)=1;
  g1(31,64)=1;
  g1(32,65)=1;
  g1(33,66)=1;
  g1(34,4)=T719;
  g1(34,18)=T465*T718;
  g1(34,19)=exp(y(19))*T464*T718;
  g1(34,27)=T719;
  g1(34,34)=exp(y(34))*y(60)+T21*(-(exp(y(4))*exp(y(27))*params(6)*(T715+exp(y(34))*exp(y(34))*getPowerDeriv(exp(y(34)),params(5)-1,2))));
  g1(34,60)=exp(y(34));
  g1(35,15)=(-(params(11)*T331*T351));
  g1(35,16)=exp(y(16));
  g1(35,17)=(-(T351*T407));
  g1(35,18)=(-(T351*T503));
  g1(35,23)=(-(T351*T619));
  g1(36,1)=exp(y(1));
  g1(36,15)=(-(params(11)*T319*T323));
  g1(36,16)=(-(T387*params(11)*T369));
  g1(37,16)=(-(T378*T341*T365*T369*exp(T329*y(23))*(1-params(11))*(1-params(3))));
  g1(37,17)=(-(T378*T419));
  g1(37,18)=(-(T378*T341*T412*T415*T341*T482+T341*T365*T412*T497));
  g1(37,21)=exp(y(21));
  g1(37,23)=(-(T378*T341*T365*T319*(1-params(11))*(1-params(3))*T329*exp(T329*y(23))));
  g1(38,16)=(-(T343*T364*T365*exp(T329*y(23))*(1-params(11))*params(3)*T369));
  g1(38,17)=T434;
  g1(38,18)=(-(T364*T365*T425*T482+T343*T364*T425*T415*T341*T482));
  g1(38,20)=exp(y(20));
  g1(38,23)=(-(T343*T364*T365*T319*(1-params(11))*params(3)*T329*exp(T329*y(23))));
  g1(39,12)=exp(y(12));
  g1(39,17)=(-(exp(y(18)*(1-params(3)))*exp(T329*y(23))*params(3)*exp(y(17)*params(3))));
  g1(39,18)=T478;
  g1(39,23)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T329*exp(T329*y(23))));
  g1(40,2)=exp(y(25))*exp(y(2));
  g1(40,3)=exp(y(24))*exp(y(3));
  g1(40,6)=T167;
  g1(40,7)=T191;
  g1(40,10)=exp(y(6))*params(6)*exp(y(26))*params(5)*exp(params(5)*y(10));
  g1(40,11)=exp(y(7))*exp(y(27))*params(6)*params(5)*exp(y(11)*params(5));
  g1(40,16)=(-exp(y(16)));
  g1(40,17)=exp(y(17))-exp(y(17))*(1-params(10));
  g1(40,19)=exp(y(19));
  g1(40,24)=exp(y(24))*exp(y(3));
  g1(40,25)=exp(y(25))*exp(y(2));
  g1(40,26)=T167;
  g1(40,27)=T191;
  g1(41,18)=exp(y(18));
  g1(41,21)=(-(T551*T556));
  g1(42,20)=(-(T36*exp(y(20))));
  g1(42,22)=(-(T36*(1+exp(y(20))-params(10))));
  g1(43,18)=(-((T21*T465*params(1)-T465*T21*params(1))/(T21*T21)));
  g1(43,19)=(-((T21*params(1)*exp(y(19))*T464-T21*params(1)*exp(y(19))*T464)/(T21*T21)));
  g1(43,22)=T36;
  g1(44,1)=(-(T36*exp(y(1))*exp(y(11))));
  g1(44,11)=T268;
  g1(44,13)=1-T36*(1-exp(y(11)));
  g1(44,22)=T583;
  g1(44,26)=(-(T36*(-(params(6)*exp(y(26))*exp(y(11)*params(5))))));
  g1(45,13)=(-params(7));
  g1(45,14)=1-T36*(1-params(7));
  g1(45,22)=(-(y(14)*T36*(1-params(7))));
  g1(46,3)=y(14)*T88*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(46,14)=T88*params(4)*exp(y(3)*(params(4)-1));
  g1(46,24)=(-exp(y(24)));
  g1(47,1)=(-(exp(y(1))*T36));
  g1(47,11)=T36*params(6)*params(5)*exp(y(26))*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(47,13)=T36;
  g1(47,22)=T567;
  g1(47,26)=T36*params(6)*params(5)*exp(y(26))*exp(y(11)*(params(5)-1));
  g1(48,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(48,9)=(-(params(7)*exp(y(9))));
  g1(48,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(49,6)=exp(y(6))-exp(y(6))*(1-exp(y(10)));
  g1(49,8)=(-(exp(y(8))*params(7)));
  g1(49,10)=(-(exp(y(6))*(-exp(y(10)))));
  g1(50,3)=(-(T88*params(4)*exp(params(4)*y(3))));
  g1(50,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(51,2)=(-(T69*params(4)*exp(y(2)*params(4))));
  g1(51,8)=exp(y(8))-exp(y(8))*(1-params(7));
  g1(52,5)=exp(y(5));
  g1(52,7)=(-(exp(y(11))*exp(y(7))));
  g1(52,11)=(-(exp(y(11))*exp(y(7))));
  g1(53,4)=exp(y(4));
  g1(53,6)=(-(exp(y(6))*exp(y(10))));
  g1(53,10)=(-(exp(y(6))*exp(y(10))));
  g1(54,4)=(-exp(y(4)));
  g1(54,5)=(-exp(y(5)));
  g1(54,15)=exp(y(15));
  g1(55,23)=1-(params(15)+params(16));
  g1(56,24)=1-(params(18)+params(19));
  g1(57,25)=1-(params(21)+params(22));
  g1(58,26)=1-(params(24)+params(25));
  g1(59,27)=1-(params(27)+params(28));
  g1(60,10)=(-exp(y(10)));
  g1(60,34)=exp(y(34));
  g1(61,28)=1;
  g1(62,29)=1;
  g1(63,30)=1;
  g1(64,31)=1;
  g1(65,32)=1;
  g1(66,33)=1;
  g1(67,55)=(-1);
  g1(67,67)=1;
  g1(68,56)=(-1);
  g1(68,68)=1;
  g1(69,57)=(-1);
  g1(69,69)=1;
  g1(70,58)=(-1);
  g1(70,70)=1;
  g1(71,59)=(-1);
  g1(71,71)=1;
  g1(72,23)=(-1);
  g1(72,72)=1;
  g1(73,24)=(-1);
  g1(73,73)=1;
  g1(74,25)=(-1);
  g1(74,74)=1;
  g1(75,26)=(-1);
  g1(75,75)=1;
  g1(76,27)=(-1);
  g1(76,76)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],76,5776);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],76,438976);
end
end
end
end
